*******************************************************************************
*                          680xx Grundprogramm wert                           *
*                         (C) 1989 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             Wert-Berechnung                                 *
*******************************************************************************


zuweis:                 * Trgt ein Symbol in die Symboltabelle ein
 move.l a0,-(a7)        * a0 zeigt auf Text
 bsr setigname          * Carry wenn nicht OK
 bcs.s zuwf             * Fehler, dann Ende
 bsr.s igbn             * Leerzeichen ignorieren
 cmp.b #':',(a0)+       * Check ob :=
 bne.s zuwf             * Wenn nicht, dann Fehler
 cmp.b #'=',(a0)+
 bne.s zuwf
 movem.l d2/d3,-(a7)    * Namen retten
 bsr.s wert             * Wert holen
 movem.l (a7)+,d2/d3
 bcs.s zuwf             * Abbruch bei Fehler
 addq.l #4,a7           * a0 auf Stack nicht mehr wichtig
 movem.l d2/d3,nametab(a5)  * Namenstabelle wieder herstellen
 bsr newval             * Neues Symbol ?
 bcc.s zuw1             * OK, Wert eingetragen
 move.l d0,datenwert(a3)* War schon da einfach setzen
 move d1,attribut(a3)
zuw1:
bra carres              * OK, zugewiesen
zuwf:
 movea.l (a7)+,a0
bra carset              * Fehler

igbn:                   * Leerzeichen ignorieren
 cmp.b #' ',(a0)+
 beq.s igbn
 subq.l #1,a0
rts

wertmfeh:                       * Wert mit Fehlertest und ohne zerstrte
 movem.l d2/d3/a1-a3,-(a7)      * Register auer d1
 bsr.s wert                     * Wert berechnen
 movem.l (a7)+,d2/d3/a1-a3
 bcs carset                     * Fehler
 cmp #5,d1
 beq carset                     * Undefiniertes Symbol ist auch Fehler
bra carres

wert:
 bsr.s igbn                     * Leerzeichen nicht beachten
 bsr.s expr                     * Expression holen
 tst d1                         * Rev 6.0 d1.w
 beq carset                     * Syntaxfehler
 cmp #5,d1                      * Bei undefiniertem Synbol carres
 beq carres
 cmp.b #'.',(a0)                * Grenangabe ?
 bne.s werta                    * Nein, dann weiter
 addq.l #1,a0                   * Sonst auswerten
 move.b (a0)+,d1
 and.b #$df,d1                  * Grobuchstabe
 cmp.b #'L',d1                  * Langwort
 beq.s wertlo
 cmp.b #'W',d1                  * Wort
 beq.s wertwo
 cmp.b #'B',d1                  * Byte
 beq.s wertby
 subq.l #2,a0
werta:
 swap d0                        * Eingang wenn nicht .B .W .L
 tst d0                         * =0 dann Wort oder Byte
 beq.s wertb
 swap d0
wertlo:                         * Langwort
 moveq #3,d1
bra.s wertend

wertb:
 swap d0
 move d0,d1
 and #$ff00,d1                  * =0 dann Byte
 beq.s wertby
wertwo:                         * Wort
 moveq #2,d1
bra.s wertend
wertby:                         * Byte
 moveq #1,d1

wertend:
 tst.b (a0)                     * Endekennung mit Null ?
 beq carres                     * Ja, dann weiter
 cmp.b #' ',(a0)                * Oder mit Leerzeichen
 beq carres
 moveq #0,d1                    * Sonst Syntaxfehler
bra carset                      * Und carry

expr:                           * Expression auswerten
 moveq #3,d1
exprin:
 bsr.s term                     * Term auswerten
exprwh:
 cmp.b #'+',(a0)                * Addition
 beq.s expradd
 cmp.b #'-',(a0)                * Subtraktion
 beq.s exprsub
 cmp.b #'!',(a0)                * Oder-Verknpfung
 beq.s expror
rts

expradd:                        * Addition
 addq.l #1,a0
 move.l d0,-(a7)
 bsr.s term                     * Wert holen
 add.l (a7)+,d0                 * Alten Wert addieren
bra.s exprwh

exprsub:                        * Subtraktion
 addq.l #1,a0                   * Nchstes Zeichen
 move.l d0,-(a7)
 bsr.s term                     * Wert holen
 neg.l d0                       * Negieren
 add.l (a7)+,d0                 * Alten Wert addieren
bra.s exprwh

expror:                         * Oder-Verknpfung
 addq.l #1,a0                   * Nchstes Zeichen
 move.l d0,-(a7)
 bsr.s term                     * Wert holen
 or.l (a7)+,d0                  * ODER-Verknpfung
bra.s exprwh

term:                           * Term berechnen
 bsr.s faktor                   * Faktor berechnen
termwh:
 cmp.b #'*',(a0)                * Multiplikation
 beq.s termmul
 cmp.b #'/',(a0)                * Division
 beq.s termdiv
 cmp.b #'\',(a0)                * Modulo
 beq.s termmod
 cmp.b #'&',(a0)                * UND-Verknpfung
 beq.s termand
rts

termmul:                        * Multiplikation
 addq.l #1,a0
 move.l d0,-(a7)
 bsr.s faktor                   * Wert holen
 move.l (a7)+,d2
 move.l d1,-(a7)
 bsr muls32                     * Multiplizieren
 move.l (a7)+,d1
bra.s termwh

termdiv:                        * Division
 addq.l #1,a0
 move.l d0,-(a7)
 bsr.s faktor                   * Wert holen
 move.l (a7)+,d2
 tst.l d0                       * Durch Null, dann Unendlich als Ergebnis
 beq.s term1div
 exg d0,d2                      * Austauschen fr Division
 move.l d1,-(a7)
 bsr divs32                     * Dividieren
 move.l (a7)+,d1
bra.s termwh
term1div:
 move.l #$7fffffff,d0           * Unendlich, da Division durch Null
bra.s termwh

termmod:                        * Modulo
 addq.l #1,a0
 move.l d0,-(a7)
 bsr.s faktor                   * Wert holen
 move.l (a7)+,d2
 tst.l d0                       * Soll durch Null geteilt werden ?
 beq.s term1div                 * Dann Unendlich als Ergebnis
 exg d0,d2                      * Austauschen
 move.l d1,-(a7)
 bsr divs32                     * Division durchfhren
 move.l d1,d0                   * Aber Rest nehmen
 move.l (a7)+,d1
bra.s termwh

termand:                        * UND-Verknpfung
 addq.l #1,a0
 move.l d0,-(a7)
 bsr.s faktor                   * Wert holen
 and.l (a7)+,d0                 * Verknpfen
bra.s termwh

faktor:                         * Faktor berechnen
 cmp.b #$27,(a0)                * Wenn ' -Zeichen, dann ASCII-Folge
 bne.s fakto11
 addq.l #1,a0
 moveq #0,d0                    * d0 lschen frs Aufaddieren
fakto12:                        * Auch ''' erlaubt
 cmp.b #$27,(a0)                * ' - Zeichen, dann Extratest
 bne.s fakto13
 cmp.b #$27,1(a0)               * Wenn '', dann ' bernehmen
 bne.s fakto14                  * Wenn ' dann Ende
fakto13:
 cmp.b #' ',(a0)                * Wenn Ctrl-Zeichen, dann Abbruch
 bcs.s fakto15
 rol.l #8,d0                    * Sonst Zeichen bernehmen
 move.b (a0)+,d0                * Nach d0
bra.s fakto12                   * Nchstes Zeichen testen

fakto14:
 addq.l #1,a0
fakto15:                        * Fehlerbehandlung
 cmp #5,d1                      * Bei undefinert, so lassen
 beq carres
 moveq #3,d1                    * Sonst Long annehmen
rts

fakto11:                        * Programmstand beim Assembler
 cmp.b #'*',(a0)
 bne.s faktok1
 move.l anfstand(a5),d0         * Zeilenanfangsadresse
bra.s fakto14

faktok1:                        * Textanfangsadresse
 cmp.b #'?',(a0)
 bne.s fakto1
 move.l stxtxt(a5),d0           * Anfangsadresse Editor
bra.s fakto14

fakto1:                         * A..Z zugelassen
 move.b (a0),d0                 * 0..nn sind Zahlen
 bsr bucheck                    * Nur A..Z und a..z als Namensanfang zugelassen
 bcs.s fakt10
 cmp #5,d1                      * Wenn undefiniert, dann lassen
 beq.s faktoo1
 bsr getval                     * a0 zeigt dann hinter Namen
 tst d2                         * =0 dann Name gefunden
 bne.s fakt101
rts

faktoo1:
 bsr getval                     * Symbol holen
 tst d2
 bne.s fakt101                  * Nicht gefunden, dann weiter
 moveq #5,d1                    * Da vorher undefiniert so lassen
rts

fakt101:                        * Name nicht eingetragen
 moveq #0,d0                    * Wert ist Null
 moveq #5,d1                    * Attribut=5 Referenz ohne Definition
bra eint0                       * Symbol nur setzen

fakt10:                         * Kein Name
 cmp.b #'(',(a0)
 bne.s fakt1
 addq.l #1,a0
 bsr exprin                     * Rekursiv
 cmp.b #')',(a0)                * Mu schlieen, sonst Fehler
 bne.s fakerr
 addq.l #1,a0                   * a0 ein Zeichen weiter
rts

fakt1:
 cmp.b #'~',(a0)                * Nicht-Operation
 bne.s faktoa11
 addq.l #1,a0
 bsr faktor                     * Wert holen
 not.l d0
rts

faktoa11:
 cmp.b #'-',(a0)                * Vorzeichen
 bne.s fakt2
 addq.l #1,a0
 bsr faktor                     * Rekursiv
 neg.l d0                       * Vorzeichen ndern
rts

fakt2:
 cmp.b #'$',(a0)                * Hexadezimalwert
 bne.s fakt3
 addq.l #1,a0
 move.b (a0),d2                 * $xxxx mu sedezimal sein
 bsr sedcheck
 bcs.s fakerr                   * Fehler
 moveq #0,d0
fakt32:
 addq.l #1,a0                   * Nchstes Zeichen
 asl.l #4,d0                    * Mal 16
 add.b d2,d0                    * Aufaddieren
 move.b (a0),d2                 * Nchstes Zeichen
 bsr sedcheck
 bcc.s fakt32                   * So lange bis nicht mehr sedezimal
bra fakto15

fakerr:
 moveq #0,d0                    * Fehler im Wert, deshalb Null
 moveq #0,d1                    * Syntaxfehler
rts

fakt3:
 cmp.b #'%',(a0)
 bne.s fakt3a                   * Binre Eingabe
 addq.l #1,a0
 move.b (a0),d2                 * Wert holen
 sub.b #'0',d2
 cmp.b #1,d2
 bhi.s fakerr                   * Fehler, wenn nicht 0/1
 moveq #0,d0                    * Ergebnis
fakt310:
 asl.l #1,d0                    * d0*2
 add.b d2,d0                    * Wert addieren
 addq.l #1,a0
 move.b (a0),d2                 * Nchstes Zeichen
 sub.b #'0',d2
 cmp.b #1,d2
 bls.s fakt310                  * Fehler, wenn nicht 0/1
bra fakto15                     * Ende Binrdaten

fakt3a:
 cmp.b #'@',(a0)                * Symbol aus Traptabelle
 bne.s fakt3b                   * Adresse von Trapsymbol
 addq.l #1,a0
 bsr gettrap                    * a0-> Ende d0=Wertadresse d2=Index
bcc fakto15

fakundef:
 moveq #5,d1                    * Undefiniertes Symbol
rts

fakt3b:
 cmp.b #'!',(a0)
 bne.s fakt3c                   * Index von Trapsymbol
 addq.l #1,a0
 bsr gettrap
 bcs.s fakundef
 move.l d2,d0                   * Jetzt #!Name richtig
bra fakto15

fakt3c:
 moveq #0,d2                    * Jetzt kann nur Dezimalzahl folgen
 move.b (a0),d2
 bsr dezcheck                   * Check ob dezimal
 bcs.s fakerr                   * Nein, dann Fehler
 moveq #0,d0                    * Ergebnis = 0 setzen
fakt21:
 move.l d0,d3
 add.l d0,d0
 add.l d0,d0
 add.l d3,d0
 add.l d0,d0                    * d0.l * 10
 add.l d2,d0
 addq.l #1,a0
 move.b (a0),d2                 * Nchstes Zeichen
 bsr dezcheck
 bcc.s fakt21                   * Wiederholen bis keine Zahl mehr
bra fakto15

muls32:                         * Multiplikation 32 Bit
 movem.l d2-d5,-(a7)            * d0.l * d2.l -> d1.l, d0.l Ergebnis
 moveq #0,d5                    * Vorzeichenmerker
 tst.l d0                       * d0 positiv ?
 bpl.s muls32a                  * Ja, dann OK
 neg.l d0                       * Sonst negieren
 not.w d5                       * Vorzeichen ist negativ
muls32a:
 tst.l d2                       * d2 positiv ?
 bpl.s muls32b                  * Ja, dann OK
 neg.l d2                       * Sonst negieren
 not.w d5                       * Vorzeichen umdrehen
muls32b:                        * Neue Berechnungs-Routine
 move.l d0,d1                   * Teilt d0 und d2 jeweils in zwei 16 Bit Zahlen
 swap d1                        * auf, die dann getrennt multipliziert werden
 move.l d2,d3                   * Diese werden dann addiert und in d1 und d0
 swap d3                        * abgespeichert. Das Ergebnis liegt in d0
 move.l d2,d4                   * In d1 ist der vorzeichenbehaftete berlauf
 mulu d1,d2                     * a2*b1 = m1   (Mittlere Zahl, Teil 1)
 mulu d3,d1                     * b2*a2 = u    (Obere Zahl)
 mulu d0,d3                     * a1*b2 = m2   (Mittlere Zahl, Teil 2)
 mulu d4,d0                     * b1*a1 = l    (Untere Zahl)
 add.l d3,d2                    * (a1*b2)+(a2*b1) = m   (Mittlere Zahl)
 move.l d2,d3
 swap d2
 clr d2                         * ml  (Unterer Teil Mittlere Zahl)
 clr d3
 swap d3                        * mu  ( Oberer Teil Mittlere Zahl)
 add.l d2,d0                    * ml+l (d0 fertig Untere 32 Bit der 64 Bit Zahl)
 addx.l d3,d1                   * mu+u (d1 fertig Obere 32 Bit der 64 Bit Zahl)
 tst d5                         * Vorzeichentest
 beq.s muls32c                  * Null, also positiv
 neg.l d0                       * Nicht Null, also Vorzeichen umdrehen
 negx.l d1                      * Auch Vorzeichen von d1
muls32c:
 movem.l (a7)+,d2-d5
rts

divs32:                         * 32 Bit Division
 movem.l d2-d4,-(a7)            * d0.l / d2.l ->  d0.l Ergebnis, d1.l Rest
                                * Vorzeichen Rest wie Vorzeichen d0 vorher
 moveq #0,d4                    * Vorzeichenmerker
 tst.l d0                       * d0 positiv ?
 bpl.s divs32a
 neg.l d0                       * Nein, dann negieren
 not.l d4                       * Vorzeichen umdrehen
divs32a:
 tst.l d2                       * d2 positiv ?
 bpl.s divs32b
 neg.l d2                       * Nein, dann negieren
 not.w d4                       * Vorzeichen umdrehen
divs32b:
 moveq #0,d1                    * berlauf ist Null
 moveq #32-1,d3
divs32c:
 asl.l #1,d0                    * 1 Bit von d0
 roxl.l #1,d1                   * nach d1 bernehmen
 cmp.l d2,d1
 bcs.s divs32d                  * So lange bis Wert erreicht
 sub.l d2,d1                    * Subtrahieren
 addq #1,d0                     * Ergebnis + 1
divs32d:
dbra d3,divs32c                 * Weiter, bis alle Bit bertragen
 tst d4                         * Vorzeichen positiv ?
 bpl.s divs32e
 neg.l d0                       * Nein, dann Ergebnis negieren
divs32e:                        * d1 ist Rest
 tst.l d4
 bpl.s divs32f
 neg.l d1
divs32f:
 movem.l (a7)+,d2-d4
rts

dezcheck:                       * Test, ob Zahl zwischen
 cmp.b #'0',d2                  * Null
 bcs.s carset
 cmp.b #'9'+1,d2                * und Neun liegt
 bcc.s carset
 sub.b #'0',d2                  * Aus ASCII-Zeichen wird Zahl
bra.s carres

sedcheck:                       * Wert ASCII in d2
 cmp.b #'0',d2                  * Carry wenn Fehler sonst Zahl
 bcs.s carset
 cmp.b #'9'+1,d2
 bcc.s sed1
 sub.b #'0',d2                  * Aus ASCII-Zeichen wird Hexadezimalwert
bra.s carres

sed1:
 cmp.b #'A',d2
 bcs.s carset
 cmp.b #'F'+1,d2
 bcc.s sed2
 sub.b #'A'-10,d2               * Hier zwischen A und F / Jetzt Zahl
bra.s carres                    * OK

sed2:
 cmp.b #'a',d2                  * Auch kleine Buchstaben
 bcs.s carset
 cmp.b #'f'+1,d2
 bcc.s carset
 sub.b #'a'-10,d2               * Ebenfalls Zahl

carres:                         * Carry-Flag auf 0 setzen
 and #$fe,ccr
rts

carset:                         * Carry-Flag auf 1 setzen
 or #1,ccr
rts
                                                                                                                                                                                                                                                                             ,-(a7)                * 8 Stellen Hexadezimal ausgeben
 moveq #8-1,d1                  * a0 -> Ziel
bra.s print1x                   * d0 zerstrt
print6x:                        * 6 Stellen
 move.l d1,-(a7)
 moveq #6-1,d1
 rol.l #8,d0
bra.s print1x
print4x:                        * 4 Stellen
 move.l d1,-(a7)
 moveq #4-1,d1
 swap d0
bra.s print1x
print2x:                        * 2 Stellen
 move.l d1,-(a7)
 moveq #2-1,d1
 ror.l #8,d0
print1x:                        * d1 = Anzahl Stellen-1
 